(*| 13:34 14/10/1993 *)
UNIT EGAUtils;

INTERFACE

USES StdTypes,EGAVars;

FUNCTION GetNum(Size,Min,Max,Def: Integer): Integer;

PROCEDURE ShowPixel(CellByte: Byte; Index: Integer);

PROCEDURE ShowByte(CellByte: Byte);

PROCEDURE ShowByteVal(ShowByte: BYTE);

PROCEDURE SetEditByte(VAR EditByte: BYTE; VAR EditKeyFunc: KeyType);

PROCEDURE Continue;

FUNCTION IndexPtr(OldPtr:BytePointer; Index: Integer):BytePointer;

PROCEDURE SwapOldFonts;

IMPLEMENTATION

USES Crt,EGAScreen,EGAWait;

FUNCTION GetNum(Size,Min,Max,Def: Integer): Integer;
VAR
  Ans:LineString;
  X,Y,Result,N:Integer;
  OK:Boolean;
BEGIN
  X:=WhereX;
  Y:=WhereY;
  OK:=False;
  REPEAT
    Result:=Def;
    Readln(Ans);
    IF Length(Ans)=0 THEN
      OK:=True
    ELSE BEGIN
      Val(Ans,Result,N);
      IF (N=0) AND (Result >=Min) AND (Result <=Max) THEN
        OK:=True;
    END;
    IF NOT OK THEN BEGIN
      Write(' INVALID NUMBER! Please Re-enter.');
      Soundbell;
      PauseRdKey;           {and leave message up till key pressed}
      GotoXY(X,Y);
      ClrEol;
    END;
  UNTIL OK;
  GetNum:=Result;
END;  { GetNum }

PROCEDURE ShowPixel(CellByte: Byte; Index: Integer);
VAR
  I: Integer;
BEGIN
  IF CellByte AND Mask[Index] = 0 THEN
    Write('.')
  ELSE
    Write('*');
END;  { ShowPixel }

PROCEDURE ShowByte(CellByte: Byte);
VAR
  Index: Integer;
BEGIN
  FOR Index:=0 TO MaxCellByte DO
    ShowPixel(CellByte,Index);
END;  { ShowByte }

PROCEDURE ShowByteVal(ShowByte: BYTE);
BEGIN
  WriteCtl(CHR(ShowByte));
  Write(' ');
  WriteHex(ShowByte,2);
END;  { ShowByteVal }

PROCEDURE SetEditByte(VAR EditByte: BYTE; VAR EditKeyFunc: KeyType);
CONST
  XRef=10;
  YRef=9;
  YMax=7;
VAR
  X,Y,YMin: Integer;
  K: Char;
BEGIN
  YMin:=0;
  FOR Y:=YMin TO YMax DO  BEGIN
    GotoXY(XRef,YRef+(2*Y));
    FOR X:=0 TO 31 DO BEGIN
      WriteCtl(CHR(X+(Y*32)));
      Write(' ');
    END;
  END;
  REPEAT
    GotoXY((2*SetX)+XRef,(2*SetY)+YRef);
    WaitKey(K,EditKeyFunc);
    CASE EditKeyFunc OF
      Cleft : DEC(SetX);
      Cright: INC(SetX);
      Cup   : IF SetY > YMin THEN DEC(SetY);
      CDown : IF SetY < YMax THEN INC(SetY);
      Chome : SetX:=0;
      Cend  : SetX:=31;
      Tab   : SetX:=SetX+8;
      RTab  : SetX:=SetX-8;
    END;
    IF SetX > 31 THEN SetX:=31;
    IF SetX < 0 THEN SetX:=0;
  UNTIL ((EditKeyFunc=ESC) OR (EditKeyFunc=RET));
  EditByte:=SetX+(32*SetY);
END;  { SetEditByte }

PROCEDURE Continue;
BEGIN
  GotoXY(1,24);
  Write('Press any key to continue : ');
  PauseRdKey;
END;  { Continue }

FUNCTION IndexPtr(OldPtr:BytePointer; Index: Integer):BytePointer;
BEGIN
  IndexPtr:=Ptr(Seg(OldPtr^),Ofs(OldPtr^)+Index);
END;  { IndexPtr }

PROCEDURE SwapOldFonts;
BEGIN
  IF FontNumber = 1 THEN BEGIN
    Font1Updated := FontUpdated;
    FontFileName := Font2FileName;
    FontFileSize := Font2FileSize;
    FontCharPtrs := Font2CharPtrs;
    FontBuffer   := Font2Buffer;
    FontUpdated  := Font2Updated;
    FontNumber   := 2;
    BytesPerChar := Font2Height;
  END ELSE BEGIN
    Font1Updated := FontUpdated;
    FontFileName := Font1FileName;
    FontFileSize := Font1FileSize;
    FontCharPtrs := Font1CharPtrs;
    FontBuffer   := Font1Buffer;
    FontUpdated  := Font1Updated;
    FontNumber   := 1;
    BytesPerChar := Font1Height;
  END;
END;  { SwapOldFonts }

END.
